﻿using Inet.Viewer.Data;
using Inet.Viewer.WinForms;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace Inet.Viewer.Samples
{
    /// <summary>
    /// An example how to print with the viewer by using the API.
    /// </summary>
    public class PrintWithViewerExample
    {
        /// <summary>
        /// Main method of the example
        /// </summary>
        /// <param name="args"></param>
        [STAThread]
        public static void Main(string[] args)
        {
            URLRenderData renderData = new URLRenderData("http://localhost:9000/?report=startpage/start.rpt");
            Form form = new Form();
            ReportViewer reportViewer = new ReportViewer();
            reportViewer.ShowToolbar = false;
            reportViewer.Dock = DockStyle.Fill;
            form.Controls.Add(reportViewer);

            IReportView reportView = reportViewer.AddNewReportView(renderData);

            Button printButton = new Button();
            printButton.Click += (x, y) => { reportView.Print(); };
            printButton.Text = "Print";
            printButton.Dock = DockStyle.Top;
            form.Controls.Add(printButton);
            form.ShowDialog();
        }
    }
}
